---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：42-PF（Packet Filter）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **ALTQ連携の詳細仕様**：ALTQとの統合の具体的動作確認が不十分
  2. **pfsync同期プロトコルの詳細**：同期プロトコルの仕様詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sbin/pfctl/pfctl.c` - pfctlメインコマンド処理（関数宣言71-80行目確認）
- E-02: `sys/netpfil/pf/pf.c` - カーネルパケット処理エンジン（ヘッダ確認）
- E-03: `sys/netpfil/pf/pf.h` - PF内部データ構造
- E-04: `sys/netpfil/pf/pf_ioctl.c` - ioctlハンドラ
- E-05: `sys/netpfil/pf/pf_lb.c` - NAT/ロードバランシング
- E-06: `sys/netpfil/pf/pf_norm.c` - パケット正規化
- E-07: `sys/netpfil/pf/pf_syncookies.c` - SYN Cookie
- E-08: `sys/netpfil/pf/if_pfsync.c` - pfsync状態同期
- E-09: `sbin/pfctl/parse.y` - pf.confパーサー
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PFはOpenBSD由来の高機能パケットフィルタ | E-02（コメント37行目$OpenBSD$タグ）, E-10 | ○ |
| C-02 | pfctlでPFの管理を行う | E-01 | ○ |
| C-03 | /dev/pfデバイス経由のioctl通信 | E-01, E-04 | ○ |
| C-04 | parse.yでpf.confをパース | E-09 | ○ |
| C-05 | pf_test()がパケット処理の中核 | E-02 | ○ |
| C-06 | last-match評価がデフォルト | E-09（PFの文法定義） | ○ |
| C-07 | 状態テーブルのハッシュルックアップ | E-02 | ○ |
| C-08 | pfsyncによる状態同期 | E-08 | ○ |
| C-09 | pflogによるパケットロギング | `sys/netpfil/pf/if_pflog.c` | ○ |
| C-10 | syncookies機能 | E-07 | ○ |
| C-11 | パケット正規化（scrub） | E-06 | ○ |
| C-12 | テーブルの基数木ルックアップ | `sbin/pfctl/pfctl_radix.c`, `sys/netpfil/pf/pf_table.c` | ○ |
| C-13 | アンカーによるルール階層管理 | E-09 | ○ |
| C-14 | OS指紋検出機能 | `sbin/pfctl/pfctl_osfp.c`, `sbin/pfctl/pf.os` | ○ |
| C-15 | netlinkサポート | `sys/netpfil/pf/pf_nl.c` | ○ |
| C-16 | ルールセット更新の原子性 | E-04 | ○ |
| C-17 | ALTQ連携の具体的動作仕様 | **根拠なし** | △ |
| C-18 | pfsync同期プロトコルの詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ALTQ連携の詳細：PFルールからALTQキューへのマッピング仕様の詳細が不明
  - 候補：pfctl_altq.c / sys/net/altq/ / altq(4)マニュアル
- pfsync同期プロトコル詳細：状態同期のメッセージフォーマットと同期タイミングの詳細
  - 候補：if_pfsync.c深部 / pfsync(4)マニュアル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PFの基本的なアーキテクチャと処理フローは十分な根拠あり
- 1: 中リスク - ALTQ連携とpfsync詳細は追加調査推奨

## 6) レビュアーチェックリスト（最小）
- [ ] pf.conf構文の主要キーワードが網羅されているか確認
- [ ] Ethernet層フィルタリング（FreeBSD独自拡張）の記述が正確か確認
- [ ] pfsyncのHA構成の詳細動作を実機検証
- [ ] ALTQ連携のQoSスケジューリングアルゴリズムの記述確認
